
using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Presenter;
using System;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample for exporting the result of a comparison of 2 PDF Files to a PDF,
    /// showing how to set the export path for this comparison report.
    /// Expects 3 arguments: the paths of the 2 PDF files that will be compared,
    /// and the path for the export file. If no export file exists,
    /// a new file will be created.
    /// See the ReportingToSpecificFilename sample for an additional sample along these lines.
    /// </summary>
    public class CompareAndExportToSpecificFilename
    {
        static CompareAndExportToSpecificFilename()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how exporting the result of a comparison of 2 PDF Files to a PDF,
        /// showing how to set the export path for this comparison report.
        /// </summary>
        /// <param name="args">Expects 3 arguments: the paths of the 2 PDF files that will be compared,
        ///            and the path for the export file. If no export file exists,
        ///             a new file will be created.
        ///</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 3)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2> <PDF-File-Output>");
            }

            //Used the current i-net PDFC profile. If no profile has been previously set then the default profile will be used.
            DifferencesPDFPresenter differencesPDFPresenter = new DifferencesPDFPresenter(args[2], false);

            using (new PDFComparer()
                            .AddPresenter(differencesPDFPresenter)
                            .Compare(args[0], args[1]))
            { }
        }
    }
}